IF OBJECT_ID('PG_FORN_PG_CRED_SALDO_ABERTO') IS NULL
begin
CREATE TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[DT_MOV] [datetime] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FORN] [int] NOT NULL,
	[VLR_EM_ABERTO] [money] NOT NULL,
	[DT_PROC] [datetime] NOT NULL,
 CONSTRAINT [PK_PG_FORN_PG_CRED_SALDO_ABERTO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_PG_FORN_PG_CRED_SALDO_ABERTO] UNIQUE NONCLUSTERED 
(
	[CD_FORN] ASC,
	[DT_MOV] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] ADD  CONSTRAINT [DF_PG_FORN_PG_CRED_SALDO_ABERTO_DT_CAD]  DEFAULT (getdate()) FOR [DT_MOV]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] ADD  CONSTRAINT [DF_PG_FORN_PG_CRED_SALDO_ABERTO_CD_EMP]  DEFAULT ((1)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] ADD  CONSTRAINT [DF_PG_FORN_PG_CRED_SALDO_ABERTO_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] ADD  CONSTRAINT [DF_PG_FORN_PG_CRED_SALDO_ABERTO_VLR_EM_ABERTO]  DEFAULT ((0)) FOR [VLR_EM_ABERTO]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] ADD  CONSTRAINT [DF_PG_FORN_PG_CRED_SALDO_ABERTO_DT_PROC]  DEFAULT (getdate()) FOR [DT_PROC]

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO]  WITH CHECK ADD  CONSTRAINT [FK_PG_FORN_PG_CRED_SALDO_ABERTO_PG_FORN] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])

ALTER TABLE [dbo].[PG_FORN_PG_CRED_SALDO_ABERTO] CHECK CONSTRAINT [FK_PG_FORN_PG_CRED_SALDO_ABERTO_PG_FORN]
end

